
AGM_84D =
{
	category		= CAT_MISSILES,
	name			= "AGM_84D",
	user_name		= _("AGM-84D"),
	display_name_short = "AGM-84",
	scheme			= "Harpoon",
	class_name		= "wAmmunitionAntiShip",
	model			= "agm-84d",
	mass			= 540,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort = 0,
	Head_Type = 5,
	sigma = {20, 20, 20},
	M = 1280.0,
	H_max = 12000.0,
	H_min = -1,
	Diam = 700.0,
	Cx_pil = 19.9,
	D_max = 2000000.0,
	D_min = 22000.0,
	Head_Form = 0,
	Life_Time = 12000.0,
	Nr_max = 16,
	v_min = 170.0,
	v_mid = 230.0,
	Mach_max = 0.85,
	t_b = 0.0,
	t_acc = 6.0,
	t_marsh = 12000.0,
	Range_max = 2000000.0,
	H_min_t = 0.0,
	Fi_start = 0.25,
	Fi_rak = 3.14152,
	Fi_excort = 0.35,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	-- No exhaust (turbo)
	X_back = -2.356,
	Y_back = -0.618,
	Z_back = 0.0,
	Reflection = 0.1656,
	KillDistance = 0.0,
	
	manualWeaponFlag = 8, -- 2
	
	RouteDistData = {
		m_climb_dist_k	= 10,
		deg_turn_dist_k	= 50,
		min_cruise_vel	= 150,
		accel_dist_k	= 20,
	},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	shape_table_data =
	{
		{
			name		= "AGM-84D",
			file		= "agm-84d",
			life		= 1,
			fire		= { 0, 1},
			username	= _("AGM-84D"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1280,  
		caliber     = 0.62,  
		cx_coeff    = {1, 0.3, 0.82, 0.035, 1.25},
		L           = 6.04,
		I           = 1 / 12 * 1280.0 * 6.04 * 6.04,
		Ma          = 3,
		Mw          = 10,
		wind_sigma	= 1000.0,
		wind_time	= 20.0,
		Sw			= 1.4,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	sat_seeker = {
		CEP 					= 5.0,
		coalition				= 1,
		coalition_rnd_coeff		= 5.0,
	},
	
	seeker = {
		CEP_dist_data =  {	1000,	10,
							2000,	20},
	},

	control_block ={
		seeker_activation_dist		= 20000,
		default_cruise_height		= 50,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 1.6,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 450,
		use_horiz_dist				= 1,
		stab_aim_diff				= 0.2,
		stab_vert_diff				= 50,
	},
	
	final_autopilot =		{
		delay				= 5,
		K					= 180,
		Ki					= 0.001,
		Kg					= 4,
		finsLimit			= 0.65,
		useJumpByDefault	= 1,
		J_Power_K			= 2.4,
		J_Diff_K			= 0.2,
		J_Int_K				= 0,
		J_Angle_K			= 0.22,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.6,
		J_Trigger_Vert		= 1,
		hKp_err				= 160,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= math.rad(60),
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 8,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,	

		inertial_km_error			= 1.6,
		glide_height_abs_error		= 12.0,
		glide_height_eq_error		= 12.0,
		stab_vel_abs_error			= 16.0,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3300,
		fuel_mass		= 240.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -150,
		max_thrust		= 3500,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-3.05, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("AGM_84D"),
	warhead_air = predefined_warhead("AGM_84D"),
}

declare_weapon(AGM_84D)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM_84D}",
	attribute		= AGM_84D.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "agm84d.png",
	displayName		= _("AGM-84D Harpoon AShM"),
	Weight			= AGM_84D.mass,
	Elements  		= {{ShapeName = "agm-84d"}},
})

local wsType_Rb04 = 11040
Rb_04 =
{
	category		= CAT_MISSILES,
	name			= "Rb_04",
	user_name		= _("Rb 04E"),
	display_name_short = "Rb04",
	scheme			= "Harpoon_sf",
	class_name		= "wAmmunitionAntiShip",
	model			= "rb04",
	mass			= 625,
	
	wsTypeOfWeapon 	= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, wsType_Rb04},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 625.0,
	H_max			= 12000.0,
	H_min			= 50,
	Diam			= 500.0,
	Cx_pil			= 8,
	D_max			= 31000.0,
	D_min			= 5000.0,
	Head_Form		= 0,
	Life_Time		= 100000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 220.0,
	Mach_max		= 0.95,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 31000.0,
	H_min_t			= 500.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.12044,
	KillDistance	= 0.0,
	
	manualWeaponFlag = 2,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	LaunchDistData =
	{
		9,		7,

				125,	150,	200,	250,	300,	350,	400,		
		100,	27420,	30870,	33400,	34780,	35760,	36530,	36720,	
		200,	28960,	31320,	33560,	34870,	35810,	36550,	37270,	
		400,	30200,	31925,	33825,	35025,	35925,	36675,	37375,	
		700,	31425,	32625,	34225,	35325,	36175,	36900,	37575,	
		1000,	32225,	33175,	34600,	35625,	36425,	37125,	37800,	
		2000,	33975,	34600,	35675,	36550,	37300,	37950,	38650,	
		3000,	35150,	35650,	36600,	37350,	38100,	38750,	39450,	
		5000,	37100,	37600,	38400,	39200,	39850,	40550,	41350,	
		7000,	39100,	39600,	40300,	41100,	41900,	42600,	43900,
	},		
	
	shape_table_data =
	{
		{
			name		= "Rb_04",
			file		= "Rb04",
			life		= 1,
			fire		= { 0, 1},
			username	= _("Rb 04E"),
			index		= wsType_Rb04,
		},
	},
	
	fm = {
		mass        = 625.0,  
		caliber     = 0.500,  
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 4.6,
		I           = 1 / 12 * 625 * 4.6 * 4.6,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 1.0,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.05,
		Ma_x		= 3,
		Ma_z		= 3,
		Kw_x		= 0.05,
	},
	
	seeker = {
		delay						= 0.0,
		op_time						= 9999.0,
		FOV							= math.rad(60),
		max_w_LOS					= 0.04,
		max_target_speed			= 25.0,
		max_target_speed_rnd_coeff	= 10.0,
		ship_track_by_default		= 1,
		flag_dist					= 5000.0,
		sens_near_dist				= 10.0,
		sens_far_dist				= 30000.0,
		primary_target_filter		= 1,
		add_y						= 1.0,		
		sens_ref_rcs				= 10000.0,
		sens_ref_dist				= 30000.0,
		ship_l_error_k				= 0.4,
		mid_vel						= 220,
	},
	
	autopilot =
	{
		glide_height				= 8.0,
		dont_climb_on_cruise_height	= 1,
		vel_proj_div 				= 6.0,
		default_glide_height		= 25,
		pre_maneuver_glide_height	= 8.0,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,	
		altim_vel_k					= 4,
		min_glide_height			= 8.0,		
		
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.6,
		Ks					= 0.8,
		K					= 1.6,
		Kd 					= 0.0,
		Ki 					= 20.0,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(5),
		fins_limit			= math.rad(50),
		fins_limit_x		= math.rad(25),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},
								
		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-25),
		max_climb_ang_hdiff	= 200,
		max_dive_ang_hdiff	= -500,
		
		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 0.5,
		glide_height_eq_error	= 0.01,
		glide_height_abs_error	= 1.5,
	},	
	
	final_autopilot = {
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 8.0,
		K					= 5.2,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(15),
		fins_limit			= math.rad(50),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},
								
		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.035,
		add_out_vert			= 1,
		loft_angle				= math.rad(8),
		loft_trig_angle			= math.rad(14),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 0,
	},
	
	triggers_control = {
		sensor_tg_dist			= 8000, -- turn on seeker and start horiz. correction if target is locked
		final_maneuver_tg_dist	= 4000,
		straight_nav_tg_dist	= 1000,
		self_destruct_tg_dist	= 1000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		target_upd_jump_dist	= 20000,
		update_pos_from_input	= 0,
		can_increase_tg_dist	= 1,
		
		send_final_maneuver_by_default	= 0,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 15,
		
		check_self_destruct_dist_with_no_target = 1,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0,
	},
	
	boost = {				--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse								= 220,
		fuel_mass							= 155,
		work_time							= 150,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-2.54, 0.078, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.038,
		tail_width							= 0.4,
		smoke_color							= {1.0, 1.0, 1.0},
		smoke_transparency					= 0.9,
		custom_smoke_dissipation_factor		= 0.2,
	},
	
	warhead		= predefined_warhead("Rb_04"),
	warhead_air = predefined_warhead("Rb_04"),
}

declare_weapon(Rb_04)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{Rb_04}",
	attribute		= Rb_04.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "Rb04.png",
	displayName		= _("Rb 04E"),
	Weight			= Rb_04.mass,
	Elements  		= {{ShapeName = "rb04"}},
})


AGM_84H =
{
	category		= CAT_MISSILES,
	name			= "AGM_84H",
	user_name		= _("AGM-84H"),
	display_name_short = "AGM-84",
	scheme			= "sat_cruise_missile",
	class_name		= "wAmmunitionAntiShip",
	model			= "agm-84h",
	mass			= 675,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 675.0,
	H_max			= 13000.0,
	H_min			= -1,
	Diam			= 343.0,
	Cx_pil			= 8,
	D_max			= 270000.0,
	D_min			= 10000.0,
	Head_Form		= 0,
	Life_Time		= 100000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 237.5,
	Mach_max		= 0.95,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 270000.0,
	H_min_t			= 500.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -3.392,
	Y_back			= 0.064,
	Z_back			= 0.0,
	Reflection		= 0.1,
	KillDistance	= 0.0,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	RouteDistData = {
		m_climb_dist_k	= 10,
		deg_turn_dist_k	= 50,
		min_cruise_vel	= 150,
		accel_dist_k	= 20,
	},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "AGM-84H",
			file	 = "agm-84h",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("AGM-84H"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	fm = {
		mass        = 675,  
		caliber     = 0.343,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		
		table_scale	= 0.1,
		--Mach	  | 0.0		0.1		0.2		0.3		0.4		0.5		0.6		0.7		0.8		0.9		1.0		1.1		1.2		1.3		1.4		1.5		1.6		1.7		1.8		1.9		2.0	  |
		Cx0 	= {	0.023,	0.023,	0.023,	0.023,	0.023,	0.023,	0.023,	0.023,	0.035,	0.12,	0.45,	0.42,	0.35,	0.3,	0.29,	0.28,	0.27,	0.26,	0.255,	0.25,	0.245,},
		
		L           = 4.37,
		I           = 1500,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.2,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.6,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},
	
	seeker = {
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},
	
	control_block ={
		seeker_activation_dist		= 20000,
		default_cruise_height		= 50,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 1.6,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 450,
		use_horiz_dist				= 1,
		stab_aim_diff				= 0.2,
		stab_vert_diff				= 50,
	},
	
	final_autopilot =		{
		delay				= 5,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 1.5,
		J_Diff_K			= 0.4,
		J_Int_K				= 0,
		J_Angle_K			= 0.22,
		J_FinAngle_K		= 0.35,
		J_Angle_W			= 0.6,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 2,
		Kp_hor_err			= 350,
		Kp_hor_err_croll	= 0.064,
		Kd_hor				= 0,
		Kp_ver				= 8.2,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 50,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.7,
		max_start_y_vel		= 35,
		stab_vel			= 237.5,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -100,
		eng_max_thrust		= 3000,		
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	booster_animation = {
		start_val = 0,
	},
	
	play_booster_animation = {
		val = 0,
	},
	
	march = {
		impulse			= 690,
		fuel_mass		= 67.5,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-2.25, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.02,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},
	
	warhead		= predefined_warhead("AGM_84H"),
	warhead_air = predefined_warhead("AGM_84H"),
}

declare_weapon(AGM_84H)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM_84H}",
	attribute		= AGM_84H.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "agm84h.png",
	displayName		= _("AGM-84H SLAM-ER (Expanded Response)"),
	Weight			= AGM_84H.mass,
	Elements  		= {{ShapeName = "agm-84h"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM_84E}",
	attribute		= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,63},
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "agm84e.png",
	displayName		= _('AGM-84E Harpoon/SLAM (Stand-Off Land-Attack Missile)'),
	Weight			= 628,
	Elements  		= {{ShapeName = "agm-84e"}},
})

X_59M =
{
	category		= CAT_MISSILES,
	name			= "X_59M",
	user_name		= _("Kh-59M (AS-18 Kazoo)"),
	display_name_short = _("Kh-59"),
	scheme			= "AGM-84E",
	class_name		= "wAmmunitionAntiShip",
	model			= "X-59M",
	mass			= 930,

	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,X_59M}, -- 54

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {10, 10, 10},
	M				= 930,
	H_max			= 10000,
	H_min			= -1,
	Diam			= 380,
	Cx_pil			= 19.64,
	D_max			= 115000,
	D_min			= 10000,
	Head_Form		= 0,
	Life_Time		= 1800,
	Nr_max			= 16,
	v_min			= 170,
	v_mid			= 250,
	Mach_max		= 0.85,
	t_b				= 0,
	t_acc			= 6,
	t_marsh			= 500,
	Range_max		= 115000,
	H_min_t			= 0,
	Fi_start		= 0.37,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	Reflection		= 0.2,
	KillDistance	= 0,
	X_back			= -0.88,
	Y_back			=-0.67,
	Z_back			= 0,
	X_back_acc		= -3,
	Y_back_acc		= -0.196,
	Z_back_acc		= 0,

	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},

	shape_table_data = {{
		name	 = "X-59M",
		file	 = "X-59M",
		username = _("Kh-59M"),
		index	 = WSTYPE_PLACEHOLDER,
	}},

	fm = {
		mass		= 930,
		caliber		= 0.380,
		cx_coeff	= {1, 0.3, 0.65, 0.018, 1.6},
		L			= 5.37,
		I			= 1500,
		Ma			= 3,
		Mw			= 10,
		wind_sigma	= 0,
		wind_time	= 0,
		Sw			= 1.2,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,

		addDeplSw			= 0.6,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,
	},

	seeker = {
		delay				= 0,
		op_time				= 800,
		activate_on_update	= 1,
		FOV					= math.rad(60),
		max_w_LOS			= 0.5,
		max_w_LOS_surf		= 0.016,

		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 40000,
	},

	ins = {
		aim_sigma		= 350,
		check_AI		= 1,
		error_coeff		= 0.05,
	},

	control_block = {
		default_cruise_height		= 100,
	},

	triggers_control = {
		action_wait_timer				= 5,	-- wait for dist functions n sen, then set default values
		default_sensor_tg_dist			= 40000, -- turn on seeker and start horiz. correction if target is locked
		default_final_maneuver_tg_dist	= 7000,
		default_straight_nav_tg_dist	= 7000,
		default_destruct_tg_dist		= 3000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		trigger_by_path					= 0,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 100,	-- triggers st nav instead of fin. maneuver if h>2*pre_maneuver_glide_height at fin. maneuver distance
		min_cruise_height				= 100,
		min_cruise_height_trigger_sum	= 0,
		min_cruise_height_trigger_mlt	= 0,
	},

	autopilot = {
		glide_height				= 200,
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6,
		default_glide_height		= 200,
		pre_maneuver_glide_height	= 200,
		skim_glide_height			= 200,
		use_start_bar_height		= 0,
		altim_vel_k					= 4,

		delay				= 2,
		op_time				= 9999,
		Kw					= 3.5,
		Ks					= 0.9,
		K					= 1.4,
		Kd 					= 0,
		Ki 					= 20,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(5),
		fins_limit			= math.rad(50),
		fins_limit_x		= math.rad(25),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},

		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-25),
		max_climb_ang_hdiff	= 200,
		max_dive_ang_hdiff	= -500,

		Ksd						= 0,
		Ksi						= 0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		glide_height_eq_error	= 8,
		glide_height_abs_error	= 5,
	},

	final_autopilot = {
		delay				= 1,
		op_time				= 9999,
		Kw					= 1,
		Ks					= 5,
		K					= 5,
		Kd 					= 0,
		Ki 					= 0,
		Kx					= 0,
		Kix					= 0,
		w_limit				= math.rad(15),
		fins_limit			= math.rad(50),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},

		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.1,
		add_out_vert			= 1,
		loft_angle				= math.rad(8),
		loft_trig_angle			= math.rad(14),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 0,
	},
	
	controller = {
		boost_start = 0.5,
		march_start = 1.5,
	},

	boost = {
		impulse								= 235,
		fuel_mass							= 25.5,
		work_time							= 1,
		nozzle_position						= {{-2.85, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0.0}},
		nozzle_exit_area 					= 0.01368,
		tail_width							= 0.5,
		smoke_color							= {0.9, 0.9, 0.9},
		smoke_transparency					= 0.1,
		custom_smoke_dissipation_factor		= 0.3,
	},

	march = {
		impulse			= 550,
		fuel_mass		= 138.5,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3400,
		thrust_Tau		= 0.0017,

		nozzle_position						= {{-0.745, -0.475, 0.0}},
		nozzle_orientationXYZ				= {{0, 0, 0.0}},
		tail_width							= 0.2,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.2,
		custom_smoke_dissipation_factor		= 0.2,

		start_burn_effect			= 1,
		start_effect_delay			= {1,		1.3, 	1.8},
		start_effect_time			= {0.7,		1, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1,		1,	1.0},
		start_effect_x_dist			= {0,		0,	0.0},
		start_effect_x_shift		= {0, 0, 0.0},
	},

	engine_control = {
		default_speed	= 285,
		K				= 240,
		Kd				= 1,
		Ki				= 0.01,
		speed_delta		= 5,
	},

	warhead		= predefined_warhead("X_59M"),
	warhead_air = predefined_warhead("X_59M"),
}

declare_weapon(X_59M)

declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{40AB87E8-BEFB-4D85-90D9-B2753ACF9514}",
	wsTypeOfWeapon	= X_59M.wsTypeOfWeapon,
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, AKU_58_X_59, "Cruise missiles"}, -- 171
	Count			= 1,
	Cx_pil			= LauncherData.AKU58.Cx_pil + X_59M.Cx_pil / 4096,
	Cx_item			= X_59M.Cx_pil / 4096,
	Picture			= "kh59m.png",
	displayName		= _("Kh-59M (AS-18 Kazoo) - 930kg, ASM, IN"),
	NatoName		= "(AS-18)",
	Weight			= X_59M.mass + 186,
	Weight_Empty	= 186,
	Elements		= ContainerWithSubshapes("AKU-58", "X-59M", 1, "Point%02d")
})


AGM_86C =
{
	category		= CAT_MISSILES,
	name			= "AGM_86C",
	user_name		= _("AGM-86C"),
	display_name_short = "AGM-86",
	scheme			= "sat_cruise_missile",
	class_name		= "wAmmunitionCruise",
	model			= "agm-86",
	mass			= 2050,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 1950.0,
	H_max			= 13000.0,
	H_min			= -1,
	Diam			= 697.0,
	Cx_pil			= 8,
	D_max			= 1200000.0,
	D_min			= 20000.0,
	Head_Form		= 0,
	Life_Time		= 10000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 220.0,
	Mach_max		= 0.9,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 1200000.0,
	H_min_t			= 0.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -3.392,
	Y_back			= 0.064,
	Z_back			= 0.0,
	Reflection		= 0.1691,
	KillDistance	= 0.0,
	
	
	LaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			0,			1170000,	1200000,	
		2000,	1185000,	1185000,	1190000,	1230000,	
		7000,	1220000,	1235000,	1240000,	1245000,	
		13000,	1250000,	1250000,	1260000,	1260000,	
	},
	
	MinLaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			0,			18500,		20000,	
		2000,	21000,		24000,		26000,		63000,	
		7000,	48000,		55000,		56000,		63000,	
		13000,	84000,		88000,		95000,		100000,	
	},
	
	add_attributes = {"Cruise missiles", "Air"},
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "AGM-86C",
			file	 = "agm-86",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("AGM-86C"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1950,  
		caliber     = 0.697,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.6,
		I           = 1 / 12 * 2050.0 * 6.6 * 6.6,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.7,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	seeker = {
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},

	control_block ={
		seeker_activation_dist		= 15500,
		default_cruise_height		= 55,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	final_autopilot =		{
		delay				= 0,
		K					= 70,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
		
		inertial_km_error		= 7,		-- m for 1000m dist
		glide_height_eq_error	= 10,		-- percent
		glide_height_abs_error	= 1,
		stab_vel_abs_error		= 16.0,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3000,
		fuel_mass		= 255.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-2.25, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.002,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("AGM_86С"),
	warhead_air = predefined_warhead("AGM_86С"),
}

declare_weapon(AGM_86C)


AGM_86D = 
{
	category		= CAT_MISSILES,
	name			= "AGM_86",
	user_name		= _("AGM-86D"),
	display_name_short = "AGM-86",
	scheme			= "sat_cruise_missile",
	class_name		= "wAmmunitionCruise",
	model			= "agm-86",
	mass			= 1450,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,AGM_86},

    Escort = 0,
    Head_Type = 5,
	sigma = {20, 20, 20},
    M = 1450.0,
    H_max = 13000.0,
    H_min = -1,
    Diam = 697.0,
    Cx_pil = 8,
    D_max = 2400000.0,
    D_min = 20000.0,
    Head_Form = 0,
    Life_Time = 10000.0,
    Nr_max = 16,
    v_min = 170.0,
    v_mid = 272.0,
    Mach_max = 0.95,
    t_b = 0.0,
    t_acc = 5.0,
    t_marsh = 10000.0,
    Range_max = 2400000.0,
    H_min_t = 0.0,
    Fi_start = 0.35,
    Fi_rak = 3.14152,
    Fi_excort = 0.7,
    Fi_search = 99.9,
    OmViz_max = 99.9,
    X_back = -3.392,
    Y_back = 0.064,
    Z_back = 0.0,
    Reflection = 0.1691,
    KillDistance = 0.0,
		
	LaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			2375000,	2380000,	2405000,	
		2000,	2385000,	2390000,	2400000,	2430000,	
		7000,	2420000,	2420000,	2430000,	2445000,	
		13000,	2440000,	2440000,	2450000,	2450000,	
	},
		
	MinLaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			19500,		20500,		22000,	
		2000,	23500,		25000,		27500,		30500,	
		7000,	53000,		53500,		58500,		63500,	
		13000,	93000,		93000,		102000,		105000,	
	},
	
	add_attributes = {"Cruise missiles", "Air"},

	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "AGM-86D",
			file	 = "agm-86",
			life	 = 2,
			fire	 = { 0, 1},
			username = _("AGM-86D"),
			index	 = AGM_86,
		},
	},
	
	fm = {
		mass        = 1450,  
		caliber     = 0.697,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.32,
		I           = 1 / 12 * 1450.0 * 6.32 * 6.32,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.6,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	seeker = {
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},

	control_block ={
		seeker_activation_dist		= 15500,
		default_cruise_height		= 55,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	final_autopilot =		{
		delay				= 0,
		K					= 70,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3000,
		fuel_mass		= 312.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-2.25, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.002,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("AGM_86"),
	warhead_air = predefined_warhead("AGM_86"),
}

declare_weapon(AGM_86D)


declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM_86C}",
	attribute		= AGM_86C.wsTypeOfWeapon,
	Count 			= 1,
	Picture			= "AGM86.png",
	displayName		= _("AGM-86C"),
	Weight			= AGM_86C.mass,
	ejectVelocity	= 1,
	ejectPitchRate	= -10,
	Elements  		= {{ShapeName = "agm-86"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID			= "{769A15DF-6AFB-439F-9B24-5B7A45C59D16}",
	attribute		= AGM_86D.wsTypeOfWeapon,
	Picture			= "AGM86.png",
	displayName		= _("AGM-86D"),
	Weight			= AGM_86D.mass,
	ejectVelocity	= 1,
	ejectPitchRate	= -10,
	Elements		= {{ShapeName =	"AGM-86"}},
})
			
declare_loadout({
	category 		= CAT_MISSILES,
	CLSID			= "{22906569-A97F-404B-BA4F-D96DBF94D05E}",
	attribute		= AGM_86D.wsTypeOfWeapon,
	Picture			= "AGM86.png",
	displayName		= _("20 x AGM-86D"),
	Weight			= AGM_86C.mass * 20,
	Count			= 20,
	ejectVelocity	= 1,
	ejectPitchRate	= -10,
	Elements		= {{ShapeName =	"AGM-86"}},
})

--
-- Chinese anti-ship, cruise missiles
--

C_802AK =
{
	category		= CAT_MISSILES,
	name			= "C_802AK",
	user_name		= _("C-802AK"),
	display_name_short = "C-802",
	scheme			= "Harpoon",
	class_name		= "wAmmunitionAntiShip",
	model			= "c802ak",
	mass			= 600,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 600.0,
	H_max			= 7500.0,
	H_min			= -1,
	Diam			= 360.0,
	Cx_pil			= 8,
	D_max			= 180000.0,
	D_min			= 12000.0,
	Head_Form		= 0,
	Life_Time		= 100000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 290.0,
	Mach_max		= 0.95,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 180000.0,
	H_min_t			= 500.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= 0,
	Y_back			= 0,
	Z_back			= 0,
	Reflection		= 0.25,
	KillDistance	= 0.0,
	
	manualWeaponFlag = 2,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	LaunchDistData =
	{
		17,		9,

				100,	150,	200,	250,	300,	350,	400,	450,	500,		
		100,	153750,	158875,	162725,	165775,	168450,	170975,	173325,	175650,	178325,	
		200,	153525,	159050,	162925,	165925,	168625,	171150,	173500,	175800,	178325,	
		300,	153750,	159250,	163125,	166175,	168850,	171375,	173700,	176000,	178825,	
		400,	154000,	159475,	163375,	166350,	169050,	171600,	173925,	176550,	179025,	
		500,	154250,	159725,	163575,	166575,	169275,	171850,	174150,	176400,	178975,	
		600,	154450,	159950,	163800,	166750,	169500,	172050,	174350,	176600,	179400,	
		700,	154550,	160250,	164050,	167050,	169700,	172300,	174600,	176800,	179200,	
		800,	154800,	160650,	164400,	167350,	170000,	172500,	174750,	177000,	179750,	
		900,	155300,	161100,	164750,	167600,	170250,	172750,	174950,	177150,	179950,	
		1000,	155950,	161700,	165150,	167950,	170500,	173000,	175200,	177350,	179950,	
		2000,	161300,	164300,	167000,	169500,	172000,	174500,	176500,	178900,	181500,	
		3000,	163500,	166100,	168500,	171000,	173600,	176200,	178200,	180300,	182900,	
		4000,	165200,	167900,	170100,	172400,	174900,	177800,	179900,	181900,	184600,	
		5000,	166800,	169500,	171800,	174000,	176300,	179100,	181700,	184500,	187200,	
		6000,	168000,	170750,	174000,	175500,	178500,	180500,	183750,	186000,	189250,	
		7000,	170250,	173000,	174750,	177750,	180250,	182750,	185000,	188500,	191250,	
		7500,	171250,	174000,	176500,	178750,	181250,	183750,	186250,	189000,	192500,	
	},

	MinLaunchDistData =
	{
		17,		9,

				100,	150,	200,	250,	300,	350,	400,	450,	500,		
		100,	17375,	12425,	12575,	12950,	13300,	13650,	14025,	15075,	18225,	
		200,	11675,	12075,	12350,	12600,	12850,	13275,	13500,	14375,	15400,	
		300,	11700,	12100,	12350,	12650,	12975,	13275,	13575,	14150,	19250,	
		400,	11725,	12100,	12400,	12800,	13050,	13400,	13650,	18775,	19175,	
		500,	11750,	12125,	12475,	12850,	13150,	13500,	13775,	14200,	15875,	
		600,	11750,	12150,	12550,	12900,	13250,	13600,	13850,	14300,	19700,	
		700,	11750,	12150,	12600,	13000,	13350,	13650,	13950,	14350,	14850,	
		800,	11800,	12200,	12700,	13050,	13400,	13700,	14050,	14500,	19650,	
		900,	11800,	12250,	12700,	13100,	13450,	13800,	14100,	14400,	19400,	
		1000,	11850,	12250,	12750,	13150,	13500,	13850,	14200,	14600,	17450,	
		2000,	12400,	12700,	12900,	13200,	13600,	14000,	14400,	19200,	20700,	
		3000,	12400,	12600,	12800,	12900,	13100,	13300,	14400,	14700,	16100,	
		4000,	12500,	12700,	12900,	13000,	13200,	13400,	13600,	13700,	15500,	
		5000,	12600,	12800,	13000,	13200,	13300,	13500,	13700,	23100,	24100,	
		6000,	12750,	13000,	24750,	13250,	24750,	19500,	22000,	21000,	27750,	
		7000,	24250,	24250,	13250,	26250,	27000,	27000,	15500,	30500,	29500,	
		7500,	24750,	25250,	26000,	26250,	28000,	29750,	24000,	22500,	32750,	
	},
	
	shape_table_data =
	{
		{
			name		= "C_802AK",
			file		= "c802ak",
			life		= 1,
			fire		= { 0, 1},
			username	= _("C-802AK"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 600.0,  
		caliber     = 0.360,  
		cx_coeff    = {1,0.39,0.38,0.3,1.31},
		L           = 5.145,
		I           = 1 / 12 * 600.0 * 5.145 * 5.145,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 0.95,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.05,
		Ma_x		= 3,
		Ma_z		= 3,
		Kw_x		= 0.01,
	},
	
	seeker = {
		delay						= 0.0,
		op_time						= 9999.0,
		FOV							= math.rad(60),
		max_w_LOS					= 0.06,
		max_target_speed			= 33.0,
		max_target_speed_rnd_coeff	= 10.0,
		ship_track_by_default		= 1,
		flag_dist					= 5000.0,
		sens_near_dist				= 10.0,
		sens_far_dist				= 65000.0,
		primary_target_filter		= 1,
		add_y						= 1.5,		
		sens_ref_rcs				= 10000.0,
		sens_ref_dist				= 40000.0,
		mid_vel						= 285,
		min_detectable_rcs			= 50,
		max_small_target_rcs		= 29999.99,
		min_large_target_rcs		= 60000.00,
		
	},
	
	autopilot =
	{
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6.0,
		default_glide_height		= 1000.0,
		min_glide_height			= 18.0,
		pre_maneuver_glide_height	= 18.0,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,	
		altim_vel_k					= 4,	
		
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.6,
		Ks					= 2.0,
		K					= 1.6,
		Kd 					= 0.0,
		Ki 					= 18.0,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(5),
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(20),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},
								
		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-25),
		max_climb_ang_hdiff	= 200,
		max_dive_ang_hdiff	= -500,
		
		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 4.0,		-- m for 1000m dist
		glide_height_eq_error	= 2.0,		-- percent
	},	
	
	final_autopilot = {
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 5.0,
		K					= 6.4,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(15),
		fins_limit			= math.rad(50),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},
								
		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.075,
		add_out_vert			= 1,
		loft_angle				= math.rad(7),
		loft_trig_angle			= math.rad(12),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 1,
	},
	
	triggers_control = {
		sensor_tg_dist			= 10000, -- turn on seeker and start horiz. correction if target is locked
		final_maneuver_tg_dist	= 6000,
		straight_nav_tg_dist	= 1000,
		self_destruct_tg_dist	= 1000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		target_upd_jump_dist	= 40000,
		update_pos_from_input	= 0,
		can_increase_tg_dist	= 1,
		
		send_final_maneuver_by_default	= 1,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 1000,	-- triggers st nav instead 
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0,
	},
	
	boost = {				--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3300,
		fuel_mass		= 50.0,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 6000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-1.70, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
	},
	
	engine_control = {
		default_speed	= 285,
		K				= 350,
		Kd				= 1.0,
		Ki				= 0.001,
		speed_delta		= 5,
	},
	
	warhead		= predefined_warhead("C_802A"),
	warhead_air = predefined_warhead("C_802A"),
}

declare_weapon(C_802AK)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{C_802AK}",
	attribute		= C_802AK.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "c802.png",
	displayName		= _("C-802AK"),
	Weight			= C_802AK.mass,
	Elements  		= {{ShapeName = "c802ak"}},
})


YJ_83K =
{
	category		= CAT_MISSILES,
	name			= "YJ-83K",
	user_name		= _("YJ-83K"),
	display_name_short = "YJ-83",
	scheme			= "Harpoon",
	class_name		= "wAmmunitionAntiShip",
	model			= "yj83k",
	mass			= 560,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort       = 0,
	Head_Type    = 5,
	sigma        = {30, 30, 20},
	M            = 560,
	H_max        = 10000.0,
	H_min        = -1,
	Diam         = 360.0,
    Cx_pil       = 1,
    D_max        = 180000.0,
    D_min        = 5000.0,
    Head_Form    = 1,
    Life_Time    = 1850.0,
    Nr_max       = 6,
    v_min        = 100.0,
    v_mid        = 285.0,
    Mach_max     = 1.1,
    t_b          = 0.0,
    t_acc        = 5,
    t_marsh      = 1800.0,
    Range_max    = 180000.0,
    H_min_t      = 0.0,
    Fi_start     = 0.25,
    Fi_rak       = 3.14152,
    Fi_excort    = 0.35,
    Fi_search    = 99.9,
    OmViz_max    = 99.9,
    Stage_       = 2,
    Engine_Type_ = 6,
    Stage        = 2,
    Engine_Type  = 6,
    exhaust1     = tail_solid,
    X_back       = -2.566,
    Y_back       = 0.0,
    Z_back       = 0.0,
    X_back_acc   = -3.9,
    Y_back_acc   = 0.0,
    Z_back_acc   = 0.0,
    Reflection   = 0.121,
    KillDistance = 0.0,
	
	manualWeaponFlag = 2,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	shape_table_data =
	{
		{
			name		= "YJ-83K",
			file		= "yj83k",
			life		= 1,
			fire		= { 0, 1},
			username	= _("YJ-83K"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 560,
		caliber     = 0.36,
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 5.145,
		I           = 1 / 12 * 560 * 5.145 * 5.145,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 0.9,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.05,
		Ma_x		= 3,
		Ma_z		= 3,
		Kw_x 		= 0.05,
	},
	
	seeker = {
		delay						= 0.0,
		op_time						= 9999.0,
		FOV							= math.rad(60),
		max_w_LOS					= 0.06,
		max_target_speed			= 33.0,
		max_target_speed_rnd_coeff	= 10.0,
		ship_track_by_default		= 1,
		flag_dist					= 5000.0,
		sens_near_dist				= 10.0,
		sens_far_dist				= 65000.0,
		primary_target_filter		= 1,
		add_y						= 1.5,		
		sens_ref_rcs				= 10000.0,
		sens_ref_dist				= 40000.0,
		ship_l_error_k				= 0.33,
		mid_vel						= 285,
		min_detectable_rcs			= 50,
		max_small_target_rcs		= 29999.99,
		min_large_target_rcs		= 60000.00,
	},
	
	autopilot =
	{
		glide_height				= 15.0,
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6.0,
		default_glide_height		= 200,
		pre_maneuver_glide_height	= 20,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,	
		altim_vel_k					= 4,
		min_glide_height			= 15,		
		
		delay				= 0,
		op_time				= 9999,
		Kw					= 2.0,
		Ks					= 0.9,
		K					= 1.0,
		Kd 					= 0.01,
		Ki 					= 15.0,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(5),
		fins_limit			= math.rad(50),
		fins_limit_x		= math.rad(25),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},
								
		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-25),
		max_climb_ang_hdiff	= 200,
		max_dive_ang_hdiff	= -500,
		
		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 0.5,
		glide_height_eq_error	= 0.01,
		glide_height_abs_error	= 1.5,
		
		cumulative_inertial_error = 1,
	},	
	
	final_autopilot = {
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 6.0,
		K					= 5.0,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(10),
		fins_limit			= 0.88,
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},
								
		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.028,
		add_out_vert			= 1,
		loft_angle				= math.rad(8),
		loft_trig_angle			= math.rad(14),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 1,
	},
	
	triggers_control = {
		sensor_tg_dist			= 10000, -- turn on seeker and start horiz. correction if target is locked
		final_maneuver_tg_dist	= 5000,
		straight_nav_tg_dist	= 1000,
		self_destruct_tg_dist	= 1000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		target_upd_jump_dist	= 40000,
		update_pos_from_input	= 0,
		can_increase_tg_dist	= 1,
		
		send_final_maneuver_by_default	= 1,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 1000,
		
		check_self_destruct_dist_with_no_target = 1,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.02,
	},
	
	boost = {
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0.0, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,	
	},
	
	march = {
		impulse			= 3300,
		fuel_mass		= 50.0,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 4000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-1.8, -0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.02,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 0,
	},
	
	engine_control = {
		default_speed	= 285,
		K				= 350,
		Kd				= 1.0,
		Ki				= 0.001,
		speed_delta		= 10,
	},

	warhead		= predefined_warhead("YJ_83"),
	warhead_air = predefined_warhead("YJ_83"),
}

declare_weapon(YJ_83K)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{YJ_83K}",
	attribute		= YJ_83K.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "yj83.png",
	displayName		= _("YJ-83K"),
	Weight			= YJ_83K.mass,
	Elements  		= {{ShapeName = "yj83k"}},
})


YJ_12 =
{
	category		= CAT_MISSILES,
	name			= "YJ-12",
	user_name		= _("YJ-12"),
	display_name_short = "YJ-12",
	scheme			= "anti_ship_missile_ramjet",
	class_name		= "wAmmunitionAntiShip",
	model			= "yj12",
	mass			= 1750,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort         = 0,
    Head_Type      = 5,
    sigma          = {8, 8, 8},
    M              = 1750.0,
    H_max          = 15000.0,
    H_min          = -1,
    Diam           = 756.0,
    Cx_pil         = 1,
    D_max          = 420000.0,
    D_min          = 12000.0,
    Head_Form      = 1,
    Life_Time      = 1850.0,
    Nr_max         = 15,
    v_min          = 170.0,
    v_mid          = 850.0,
    Mach_max       = 3.5,
    t_b            = 2.0,
    t_acc          = 5.0,
    t_marsh        = 1800.0,
    Range_max      = 420000.0,
    H_min_t        = 0.0,
    Fi_start       = 3.14152,
    Fi_rak         = 3.14152,
    Fi_excort      = 3.14152,
    Fi_search      = 99.9,
    OmViz_max      = 99.9,
    Stage_         = 2,
    Engine_Type    = 5,
    X_back         = -2.5,
    Y_back         = 0.0,
    Z_back         = 0.0,
    X_back_acc     = -3.5,
    Y_back_acc     = 0.0,
    Z_back_acc     = 0.0,
    exhaust1       = tail_solid,
    Reflection     = 1.0,
    KillDistance   = 0.0,

    manualWeaponFlag = 2,

	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	LaunchDistData =
	{
		20,		9,

				150,	200,	250,	300,	350,	400,	450,	500,	550,		
		100,	105000,	105000,	106000,	106000,	106000,	107000,	114000,	116000,	117000,	
		200,	106000,	107000,	107000,	107000,	107000,	108000,	115000,	117000,	119000,	
		300,	107000,	108000,	108000,	108000,	109000,	110000,	117000,	119000,	120000,	
		500,	110000,	110000,	110000,	110000,	111000,	118000,	121000,	122000,	123000,	
		700,	112000,	112000,	112000,	113000,	113000,	122000,	124000,	125000,	127000,	
		1000,	115000,	115000,	115000,	115000,	124000,	128000,	129000,	130000,	131000,	
		2000,	128000,	128000,	128000,	141000,	143000,	145000,	146000,	147000,	148000,	
		3000,	142000,	142000,	158000,	160000,	162000,	164000,	164000,	166000,	166000,	
		4000,	160000,	174000,	180000,	184000,	184000,	186000,	186000,	188000,	188000,	
		5000,	180000,	204000,	208000,	210000,	210000,	212000,	214000,	214000,	216000,	
		6000,	204000,	236000,	238000,	240000,	242000,	242000,	244000,	246000,	246000,	
		7000,	262000,	268000,	272000,	274000,	274000,	276000,	278000,	278000,	280000,	
		8000,	298000,	304000,	308000,	310000,	312000,	312000,	314000,	316000,	318000,	
		9000,	338000,	344000,	348000,	350000,	352000,	354000,	356000,	358000,	358000,	
		10000,	405000,	405000,	405000,	405000,	405000,	405000,	410000,	410000,	410000,	
		11000,	405000,	405000,	405000,	405000,	405000,	410000,	410000,	410000,	410000,	
		12000,	405000,	405000,	405000,	410000,	410000,	410000,	410000,	410000,	415000,	
		13000,	405000,	405000,	405000,	405000,	410000,	410000,	415000,	415000,	415000,	
		14000,	405000,	405000,	405000,	410000,	410000,	415000,	415000,	415000,	415000,	
		15000,	405000,	405000,	410000,	410000,	410000,	415000,	415000,	415000,	420000,	
	},

	MinLaunchDistData =
	{
		20,		9,

				150,	200,	250,	300,	350,	400,	450,	500,	550,		
		100,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	13000,	
		200,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	13000,	
		300,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	12000,	13000,	
		500,	12000,	12000,	12000,	12000,	12000,	12000,	13000,	13000,	13000,	
		700,	12000,	12000,	12000,	12000,	13000,	13000,	13000,	14000,	14000,	
		1000,	12000,	12000,	13000,	13000,	13000,	13000,	14000,	14000,	14000,	
		2000,	13000,	13000,	14000,	15000,	15000,	15000,	16000,	16000,	17000,	
		3000,	14000,	14000,	16000,	16000,	16000,	16000,	18000,	18000,	18000,	
		4000,	16000,	16000,	18000,	18000,	20000,	20000,	20000,	20000,	22000,	
		5000,	18000,	18000,	20000,	22000,	22000,	22000,	22000,	24000,	24000,	
		6000,	20000,	20000,	20000,	22000,	22000,	24000,	24000,	26000,	26000,	
		7000,	22000,	24000,	24000,	24000,	26000,	26000,	26000,	28000,	28000,	
		8000,	24000,	26000,	28000,	28000,	30000,	30000,	32000,	32000,	34000,	
		9000,	28000,	30000,	32000,	32000,	34000,	34000,	34000,	36000,	36000,	
		10000,	30000,	35000,	35000,	35000,	35000,	35000,	40000,	40000,	40000,	
		11000,	35000,	35000,	35000,	35000,	35000,	40000,	40000,	40000,	40000,	
		12000,	35000,	35000,	35000,	40000,	40000,	40000,	40000,	40000,	45000,	
		13000,	35000,	35000,	35000,	35000,	40000,	40000,	40000,	40000,	45000,	
		14000,	35000,	35000,	35000,	40000,	40000,	40000,	40000,	45000,	45000,	
		15000,	35000,	35000,	40000,	40000,	40000,	40000,	45000,	45000,	45000,	
	},
	
	encyclopediaAnimation =
	{
		args =
		{
			[1] = 1.00,
		},
	},
	
	shape_table_data =
	{
		{
			name		= "YJ-12",
			file		= "yj12",
			life		= 1,
			fire		= { 0, 1},
			username	= _("YJ-12"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	controller = {
        boost_start = 1.000,
        march_start = 6.000,
    },
	
	boost = {
        impulse                              = 220,
        fuel_mass                            = 360,
        work_time                            = 5,
        boost_time                           = 0,
        boost_factor                         = 0,
        nozzle_position                      = {{-3.5, 0, 0}},
        nozzle_orientationXYZ                = {{0.0, 0.0, 0.0}},
        tail_width                           = 0.8,
        smoke_color                          = {1, 1, 1},
        smoke_transparency                   = 1.0,
        custom_smoke_dissipation_factor      = 0.2,
        effect_type                          = 0,
    },

	march = {
		impulse							= 0,
		fuel_mass						= 700,
		work_time						= 0,
		boost_time						= 0,
		boost_factor					= 0,
		nozzle_position					= {{-3.0, 0, 0}},
		nozzle_orientationXYZ			= {{0, 0, 0}},
		tail_width						= 0.2,
		smoke_color						= {0.9, 0.9, 0.9},
		smoke_transparency				= 0.05,
		custom_smoke_dissipation_factor	= 0.45,
		effect_type						= 1,
		min_start_speed					= 360,

		inlet_area	= 0.036 * 4,
		Tchamb_max	= 2300,
		LHVof_fuel	= 43e6,
		AFR_stoich	= 14.9,
		AEC			= 1.18,
	},

    fm = {
        mass        = 1750,
        caliber     = 0.756,
        cx_coeff    = {1,0.85,0.85,0.45,1.55},
        L           = 7.0,
        I           = 1 / 12 * 1750 * 7.0 * 7.0,
        Ma          = 0.4,
        Mw          = 1.2,
        wind_sigma  = 0.0,
        wind_time   = 0.0,
        Sw          = 1.2,
        dCydA       = {0.07, 0.036},
        A           = 0.36,
        maxAoa      = 0.28,
        finsTau     = 0.1,
        lockRoll    = 1,

        Ma_x        = 0.001,
        Mw_x        = 0.15,
        I_x         = 60,
    },
        
    fuze_proximity = {
        ignore_inp_armed = 1,
    },

    seeker = {
        delay                        = 1.0,
        op_time                      = 900.0,
        FOV                          = math.rad(60),
        max_w_LOS                    = 0.05,
        max_target_speed             = 33.0,
        max_target_speed_rnd_coeff   = 10.0,
        ship_track_by_default        = 0,
        flag_dist                    = 5000.0,
        sens_near_dist               = 10.0,
        sens_far_dist                = 80000.0,
        primary_target_filter        = 0,
        add_y                        = 0.5,
    },

    autopilot =
    {
        glide_height                = 2000.0,
        dont_climb_on_cruise_height = 0,
        vel_proj_div                = 5.0,
        default_glide_height        = 2000.0,
        pre_maneuver_glide_height   = 1000.0,
        skim_glide_height           = 200.0,
        use_start_bar_height        = 1,
        altim_vel_k                 = 10,

        delay                 = 2.0,
        op_time               = 900,
        Kw                    = 1,
        Ks                    = 18,
        K                     = 18,
        Kd                    = 0.03,
        Ki                    = 0.03,
        Kx                    = 0.04,
        Kdx                   = 0.001,
        w_limit               = math.rad(6),
        fins_limit            = math.rad(50),
        fins_limit_x          = math.rad(25),
        rotated_WLOS_input    = 0,
        conv_input            = 0,
        fins_q_div            = 1,
        PN_dist_data          = {2000,    0,
                                  500,    0},

        max_climb_angle       = math.rad(20),
        max_dive_angle        = math.rad(-30),
        max_climb_ang_hdiff   = 200,
        max_dive_ang_hdiff    = -200,

        Ksd                   = 0.1,
        Ksi                   = 0.0,
        integr_val_limit      = 0.5,
        hor_err_limit         = 0.5,
                
        inertial_km_error     = 2.0,
        glide_height_eq_error = 0.5,
		
		w_limit_data        = { 2000,    math.rad(10),
								8000,    math.rad(5),    },
		
		vert_ctrl_data 		= {	100,	math.rad(-24),
								115,	math.rad(-16),
								130,	math.rad(-8),
								145,	math.rad(0),
								185,	math.rad(10),	},
		
		Kp_h				= { 15000,	5,
								2000,	20},
    },

    final_autopilot = {
        delay                = 1.0,
        op_time              = 900,
        Kw                   = 2,
        Ks                   = 10,
        K                    = 60.0,
        Kd                   = 0.15,
        Ki                   = 0.0,
        Kx                   = 0.0,
        Kix                  = 0.0,
        w_limit              = math.rad(20),
        fins_limit           = math.rad(50),
        rotated_WLOS_input   = 0,
        conv_input           = 0,
        fins_q_div           = 1,
        PN_dist_data         = {100000,    0,
								 80000,	 0.5,
								 50000,	 0.8,
                                 15000,    1},

        add_err_val          = 0.014,
        add_err_vert         = 1,
        add_out_val          = 0,
        add_out_vert         = 0,
        loft_angle           = 0,
        loft_trig_angle      = 0,
        K_loft_err           = 0,
        loft_angle_vert      = 0,
    },

	glide_h_control = {
		delay		= 0,
		k_dist		= {450000},
		k_h			= {12000},
		max_h_diff	= 2000,
	},

    triggers_control = {
        action_wait_timer                 = 3,    -- wait for dist functions n sen, then set default values
        default_sensor_tg_dist            = 60000, -- turn on seeker and start horiz. correction if target is locked
        final_maneuver_by_default         = 1,
        default_final_maneuver_tg_dist    = 30000,
        default_destruct_tg_dist          = 5000,    -- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
        trigger_by_path                   = 1,
    },
	
	warhead		= predefined_warhead("YJ_12"),
	warhead_air = predefined_warhead("YJ_12"),
}

declare_weapon(YJ_12)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{YJ_12}",
	attribute		= YJ_12.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "yj12.png",
	displayName		= _("YJ-12"),
	Weight			= YJ_12.mass,
	Elements  		= {{ShapeName = "yj12"}},
})


CM_802AKG =
{
	category		= CAT_MISSILES,
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	
	name			= "CM_802AKG",
	display_name	= _("CM-802AKG"),
	user_name		= _("CM-802AKG"),
	display_name_short = "CM-802",
	
	scheme			= "AGM-84E",
	class_name		= "wAmmunitionAntiShip",
	model			= "cm802akg",
	
	Escort		= 0,
	Head_Type	= 5,
	sigma		= {25, 25, 25},
	M			= 670.0,
	H_max		= 10000.0,
	H_min		= 500,
	Diam		= 360.0,
	Cx_pil		= 8,
	D_max		= 230000.0,
	D_min		= 15000.0,
	Head_Form	= 0,
	Life_Time	= 1850.0,
	Nr_max		= 18,
	v_min		= 150.0,
	v_mid		= 272.0,
	Mach_max	= 0.9,
	t_b			= 0.01,
	t_acc		= 5.0,
	t_marsh		= 1800.0,
	Range_max	= 230000.0,
	H_min_t		= 0.0,
	Fi_start	= 0.5,
	Fi_rak		= 3.14152,
	Fi_excort	= 1.05,
	Fi_search	= 99.9,
	OmViz_max	= 99.9,

	X_back			= -1.581,
	Y_back			= 0,
	Z_back			= 0.0,
	Reflection		= 0.25,
	KillDistance	= 0.0,
		
	Damage_correction_coeff = 0.7,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	LaunchDistData =
	{
		17,		9,

				100,	150,	200,	250,	300,	350,	400,	450,	500,		
		100,	0,		0,		205025,	208800,	211725,	214900,	217775,	220750,	224250,	
		200,	0,		200075,	205325,	208675,	212075,	215225,	218150,	221100,	224625,	
		300,	0,		200325,	205175,	209000,	212400,	215575,	218525,	221450,	224525,	
		400,	195575,	200575,	205475,	209350,	212725,	215925,	218900,	221775,	224850,	
		500,	195800,	200825,	205775,	209675,	213075,	216250,	219225,	222125,	225125,	
		600,	196000,	200600,	206050,	209950,	213400,	216550,	219500,	222400,	225300,	
		700,	196200,	200900,	206350,	210300,	213700,	216900,	219850,	222650,	225600,	
		800,	196400,	201150,	206650,	210650,	214000,	217300,	220150,	222900,	225800,	
		900,	196650,	201400,	206950,	210950,	214350,	217550,	220400,	223150,	225950,	
		1000,	196850,	201700,	207200,	211300,	214650,	217900,	220650,	223400,	226250,	
		2000,	199900,	206300,	210600,	214300,	217300,	219900,	222500,	225000,	228000,	
		3000,	204800,	209300,	213100,	216700,	219500,	222000,	224200,	226800,	229900,	
		4000,	207500,	211700,	215100,	218500,	221800,	223900,	226100,	228700,	231900,	
		5000,	209500,	213500,	217000,	220200,	223800,	226100,	228100,	230700,	234000,	
		6000,	211250,	215000,	218500,	221750,	225250,	228000,	230250,	232750,	236000,	
		7000,	213000,	216750,	220250,	223250,	226750,	230250,	232250,	235000,	238250,	
		7500,	213750,	217500,	220750,	224000,	227250,	230750,	233250,	236000,	240500,	
	},

	MinLaunchDistData =
	{
		17,		9,

				100,	150,	200,	250,	300,	350,	400,	450,	500,		
		100,	0,		0,		21700,	21950,	16325,	16775,	17100,	17900,	24150,	
		200,	0,		21475,	21425,	15950,	16450,	16950,	17450,	17975,	24000,	
		300,	0,		21250,	15475,	16050,	16600,	17125,	17550,	18125,	18900,	
		400,	22250,	21025,	15575,	16175,	16725,	17250,	17700,	18300,	19225,	
		500,	22000,	20800,	15700,	16225,	16850,	17325,	17900,	18475,	19350,	
		600,	21800,	14950,	15750,	16400,	16950,	17500,	18000,	18550,	19250,	
		700,	21550,	15000,	15800,	16400,	17000,	17550,	18050,	18650,	19350,	
		800,	21350,	15100,	15900,	16550,	17100,	17650,	18150,	18700,	19450,	
		900,	21150,	15150,	16000,	16600,	17150,	17700,	18250,	18800,	19500,	
		1000,	20900,	15200,	16000,	16650,	17300,	17800,	18300,	18900,	19600,	
		2000,	14500,	15500,	16200,	16900,	17600,	18200,	18800,	19500,	20000,	
		3000,	14600,	15100,	16000,	16900,	17300,	18300,	18900,	19600,	21200,	
		4000,	14800,	15100,	15300,	15600,	15800,	16100,	16600,	19300,	21300,	
		5000,	14900,	15200,	15500,	15700,	15900,	16200,	16600,	17000,	21300,	
		6000,	15000,	15500,	15750,	15750,	16000,	16250,	16750,	17000,	17500,	
		7000,	15250,	15500,	15750,	16000,	16250,	16500,	16500,	17000,	17500,	
		7500,	15250,	15500,	15750,	16000,	16250,	16500,	16750,	17000,	18000,	
	},
	
	shape_table_data =
	{
		{
			name		= "CM_802AKG",
			file		= "cm802akg",
			life		= 1,
			fire		= { 0, 1},
			username	= _("CM-802AKG"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
		controller = {
		boost_start	= 0,
		march_start = 0,
	},

	control_block = {
		default_cruise_height = 1000.0,
	},


	boost = {				--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse			= 3000,
		fuel_mass		= 68,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 5000,
		thrust_Tau		= 0.0018,

		nozzle_position						= {{-2.26, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,

		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
	},

	engine_control = {
		default_speed	= 285,
		K				= 240,
		Kd				= 1.0,
		Ki				= 0.01,
		speed_delta		= 5,
	},


	seeker = {
		delay				= 0.0,
		op_time				= 800,
		activate_on_update	= 1,

		FOV					= math.rad(60),

		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 30000,
	},

	ins = {
		aim_sigma		= 350,
		check_AI		= 1,
		error_coeff		= 0.03,
	},

	fm = {
		mass        = 670,
		caliber     = 0.360,
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 5.145,
		I           = 1 / 12 * 670.0 * 5.145 * 5.145,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 0.75,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.02,
		Ma_x		= 3,
		Ma_z		= 3,
		Mw_x		= 2.6,
	},

	autopilot =
	{
		glide_height				= 1000,
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6.0,
		default_glide_height		= 1000,
		pre_maneuver_glide_height	= 1000,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,
		altim_vel_k					= 4,

		delay				= 1.0,
		op_time				= 9999,
		Kw					= 4.0,
		Ks					= 1.0,
		K					= 1.0,
		Kd 					= 0.0,
		Ki 					= 30.0,--10
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(5),
		fins_limit			= math.rad(50),
		fins_limit_x		= math.rad(25),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},

		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-30),
		max_climb_ang_hdiff	= 180,
		max_dive_ang_hdiff	= -500,

		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 4.0,
		glide_height_eq_error	= 0.02,

		
		vert_ctrl_data 		= {	100,	math.rad(-24),
								115,	math.rad(-16),
								130,	math.rad(-8),
								145,	math.rad(0),
								185,	math.rad(10),	},
	},

	final_autopilot = {
		delay				= 1.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 5.0,
		K					= 5.0,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(15),
		fins_limit			= math.rad(50),
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},

		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.1,
		add_out_vert			= 1,
		loft_angle				= math.rad(8),
		loft_trig_angle			= math.rad(14),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 0,
	},

	triggers_control = {
		action_wait_timer				= 5,	-- wait for dist functions n sen, then set default values
		default_sensor_tg_dist			= 10000, -- turn on seeker and start horiz. correction if target is locked
		default_final_maneuver_tg_dist	= 7000,
		default_straight_nav_tg_dist	= 7000,
		default_destruct_tg_dist		= 3000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		trigger_by_path					= 1,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 1000,	-- triggers st nav instead of fin. maneuver if h>2*pre_maneuver_glide_height at fin. maneuver distance
		min_cruise_height				= 1000,
		min_cruise_height_trigger_sum	= 10000,
		min_cruise_height_trigger_mlt	= 285/33,
	},
	
	warhead		= predefined_warhead("C_802A"),
	warhead_air = predefined_warhead("C_802A"),
}

declare_weapon(CM_802AKG)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{CM_802AKG}",
	attribute		= CM_802AKG.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "c802akg.png",
	displayName		= _("CM-802AKG"),
	Weight			= CM_802AKG.mass,
	Elements  		= {{ShapeName = "cm802akg"}},
})


KD63 =
{
	category		= CAT_MISSILES,
	name			= "KD_63",
	user_name		= _("KD-63"),
	display_name_short = "KD-63",
	scheme			= "AGM-84E",
	class_name		= "wAmmunitionAntiShip",
	model			= "kd63",
	mass			= 2000,
	
    add_attributes  = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

    Escort          = 0,
    Head_Type       = 5,
    sigma           = {8, 8, 8},
    M               = 2000.0,
    H_max           = 10000.0,
    H_min           = 500,
    Diam            = 760.0,
    Cx_pil          = 6,
    D_max           = 200000.0,
    D_min           = 20000.0,
    Head_Form       = 0,
    Life_Time       = 1850.0,
    Nr_max          = 18,
    v_min           = 170.0,
    v_mid           = 272.0,
    Mach_max        = 0.9,
    t_b             = 5.0,
    t_acc           = 0.0,
    t_marsh         = 1800.0,
    Range_max       = 200000.0,
    H_min_t         = 0.0,
    Fi_start        = 0.5,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.05,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    -- No exhaust (turbo)
    X_back          = -3.805,
    Y_back          = -0.391,
    Z_back          = 0.0,
    Reflection      = 0.121,
    KillDistance    = 0.0,

    shape_table_data = {
        {
            name     = "KD_63",
            file     = "kd63",
            life     = 1,
            fire     = {0, 1},
            username = _("KD-63"),
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    LaunchDistData =
	{
		13,		8,

				100,	150,	200,	250,	300,	350,	400,	450,		
		100,	0,		0,		183100,	186950,	189075,	191400,	192850,	194625,	
		200,	0,		0,		183350,	187225,	188925,	191250,	193125,	194825,	
		300,	0,		0,		183600,	187025,	189300,	191525,	193325,	194950,	
		500,	0,		179575,	183675,	187650,	189950,	192000,	193675,	195275,	
		700,	0,		180200,	184550,	188150,	190350,	192200,	193850,	195450,	
		1000,	0,		181000,	185750,	188700,	190700,	192450,	194050,	195700,	
		2000,	180700,	185100,	188200,	190500,	192450,	194050,	195500,	197050,	
		3000,	183500,	187200,	190000,	192200,	194200,	195800,	197200,	198700,	
		4000,	185400,	188800,	191700,	193900,	195800,	197600,	198900,	200500,	
		5000,	186800,	190300,	193000,	195300,	197400,	199300,	200700,	202300,	
		6000,	187750,	191500,	194250,	196500,	198750,	200750,	202250,	204000,	
		8000,	190500,	194000,	196500,	199000,	201500,	203500,	205500,	207500,	
		10000,	193000,	195500,	199000,	201000,	203500,	206000,	208500,	211500,	
	},

	MinLaunchDistData =
	{
		13,		8,

				100,	150,	200,	250,	300,	350,	400,	450,		
		100,	0,		0,		23850,	22950,	23200,	22975,	16675,	17525,	
		200,	0,		0,		23350,	22375,	16000,	16600,	17075,	17500,	
		300,	0,		0,		22725,	15475,	16175,	16525,	17100,	17250,	
		500,	0,		23900,	15125,	15800,	16275,	16850,	17300,	17800,	
		700,	0,		22850,	15250,	15850,	16400,	16900,	17350,	17700,	
		1000,	0,		14650,	15450,	15950,	16500,	16950,	17350,	17850,	
		2000,	14250,	15250,	16050,	16700,	17250,	17650,	18100,	18650,	
		3000,	14500,	15600,	16300,	17100,	17900,	18500,	19000,	19500,	
		4000,	14100,	15500,	16500,	17300,	18300,	18900,	19500,	20000,	
		5000,	14000,	15100,	16300,	17300,	18400,	19100,	19700,	20400,	
		6000,	14250,	15000,	16250,	17250,	18500,	19250,	19750,	21000,	
		8000,	14500,	14500,	16000,	17500,	18500,	19000,	20000,	21500,	
		10000,	14500,	15000,	15000,	15000,	15500,	19500,	15500,	22500,	
	},

   	controller = {
		boost_start	= 0,
		march_start = 0,
	},

	control_block = {
		default_cruise_height = 600.0,
	},


	boost = {				--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse			= 3000,
		fuel_mass		= 250,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 20000,
		thrust_Tau		= 0.0018,

		nozzle_position						= {{-2.26, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,

		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
	},

	engine_control = {
		default_speed	= 250,
		K				= 240,
		Kd				= 1.0,
		Ki				= 0.01,
		speed_delta		= 5,
	},

	seeker = {
		delay				= 0.0,
		op_time				= 800,
		activate_on_update	= 1,

		FOV					= math.rad(60),

		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 30000,
	},

	ins = {
		aim_sigma		= 350,
		check_AI		= 1,
		error_coeff		= 0.03,
	},

	fm = {
		mass        = 2000,
		caliber     = 0.76,
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 7,
		I           = 1 / 12 * 2000.0 * 7 * 7,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 1.4,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.02,
		Ma_x		= 3,
		Ma_z		= 3,
		Mw_x		= 2.6,
	},

	autopilot =
	{
		glide_height				= 600,
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6.0,
		default_glide_height		= 600,
		pre_maneuver_glide_height	= 600,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,
		altim_vel_k					= 4,

		delay				= 0.5,
		op_time				= 9999,
		Kw					= 2.4,
		Ks					= 1.0,
		K					= 1.0,
		Kd 					= 0.0,
		Ki 					= 10.0,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(2.5),
		fins_limit			= 1.4,
		fins_limit_x		= 0.5,
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},

		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-30),
		max_climb_ang_hdiff	= 180,
		max_dive_ang_hdiff	= -500,

		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 6.0,
		glide_height_eq_error	= 0.03,

		
		vert_ctrl_data 		= {	100,	math.rad(-24),
								115,	math.rad(-16),
								130,	math.rad(-8),
								145,	math.rad(0),
								185,	math.rad(10),	},
	},

	final_autopilot = {
		delay				= 0.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 20.0,
		K					= 5.0,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(10),
		fins_limit			= 1.4,
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},

		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.1,
		add_out_vert			= 1,
		loft_angle				= math.rad(6),
		loft_trig_angle			= math.rad(10),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 0,
	},

	triggers_control = {
		action_wait_timer				= 5,	-- wait for dist functions n sen, then set default values
		default_sensor_tg_dist			= 11000, -- turn on seeker and start horiz. correction if target is locked
		default_final_maneuver_tg_dist	= 7000,
		default_straight_nav_tg_dist	= 7000,
		default_destruct_tg_dist		= 3000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		trigger_by_path					= 1,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 600,	-- triggers st nav instead of fin. maneuver if h>2*pre_maneuver_glide_height at fin. maneuver distance
		min_cruise_height				= 600,
		min_cruise_height_trigger_sum	= 11000,
		min_cruise_height_trigger_mlt	= 237/33,
	},	
	
    Damage_correction_coeff = 1.0,

    warhead        = predefined_warhead("KD_63"),
    warhead_air    = predefined_warhead("KD_63"),
}

declare_weapon(KD63)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{KD_63}",
	attribute		= KD63.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "kd63.png",
	displayName		= _("KD-63"),
	Weight			= KD63.mass,
	Elements  		= {{ShapeName = "kd63"}},
})

KD63B =
{
	category		= CAT_MISSILES,
	name			= "KD_63B",
	user_name		= _("KD-63B"),
	display_name_short = "KD-63",
	scheme			= "AGM-84E",
	class_name		= "wAmmunitionAntiShip",
	model			= "kd63b",
	mass			= 2000,
	
    add_attributes  = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

    Escort          = 0,
    Head_Type       = 5,
    sigma           = {8, 8, 8},
    M               = 2000.0,
    H_max           = 10000.0,
    H_min           = 500,
    Diam            = 760.0,
    Cx_pil          = 6,
    D_max           = 200000.0,
    D_min           = 20000.0,
    Head_Form       = 0,
    Life_Time       = 1850.0,
    Nr_max          = 18,
    v_min           = 170.0,
    v_mid           = 272.0,
    Mach_max        = 0.9,
    t_b             = 5.0,
    t_acc           = 0.0,
    t_marsh         = 1800.0,
    Range_max       = 200000.0,
    H_min_t         = 0.0,
    Fi_start        = 0.5,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.05,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    -- No exhaust (turbo)
    X_back          = -3.805,
    Y_back          = -0.391,
    Z_back          = 0.0,
    Reflection      = 0.121,
    KillDistance    = 0.0,

    shape_table_data = {
        {
            name     = "KD_63B",
            file     = "kd63b",
            life     = 1,
            fire     = {0, 1},
            username = _("KD-63B"),
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    LaunchDistData =
	{
		13,		8,

				100,	150,	200,	250,	300,	350,	400,	450,		
		100,	0,		0,		183100,	186950,	189075,	191400,	192850,	194625,	
		200,	0,		0,		183350,	187225,	188925,	191250,	193125,	194825,	
		300,	0,		0,		183600,	187025,	189300,	191525,	193325,	194950,	
		500,	0,		179575,	183675,	187650,	189950,	192000,	193675,	195275,	
		700,	0,		180200,	184550,	188150,	190350,	192200,	193850,	195450,	
		1000,	0,		181000,	185750,	188700,	190700,	192450,	194050,	195700,	
		2000,	180700,	185100,	188200,	190500,	192450,	194050,	195500,	197050,	
		3000,	183500,	187200,	190000,	192200,	194200,	195800,	197200,	198700,	
		4000,	185400,	188800,	191700,	193900,	195800,	197600,	198900,	200500,	
		5000,	186800,	190300,	193000,	195300,	197400,	199300,	200700,	202300,	
		6000,	187750,	191500,	194250,	196500,	198750,	200750,	202250,	204000,	
		8000,	190500,	194000,	196500,	199000,	201500,	203500,	205500,	207500,	
		10000,	193000,	195500,	199000,	201000,	203500,	206000,	208500,	211500,	
	},

	MinLaunchDistData =
	{
		13,		8,

				100,	150,	200,	250,	300,	350,	400,	450,		
		100,	0,		0,		23850,	22950,	23200,	22975,	16675,	17525,	
		200,	0,		0,		23350,	22375,	16000,	16600,	17075,	17500,	
		300,	0,		0,		22725,	15475,	16175,	16525,	17100,	17250,	
		500,	0,		23900,	15125,	15800,	16275,	16850,	17300,	17800,	
		700,	0,		22850,	15250,	15850,	16400,	16900,	17350,	17700,	
		1000,	0,		14650,	15450,	15950,	16500,	16950,	17350,	17850,	
		2000,	14250,	15250,	16050,	16700,	17250,	17650,	18100,	18650,	
		3000,	14500,	15600,	16300,	17100,	17900,	18500,	19000,	19500,	
		4000,	14100,	15500,	16500,	17300,	18300,	18900,	19500,	20000,	
		5000,	14000,	15100,	16300,	17300,	18400,	19100,	19700,	20400,	
		6000,	14250,	15000,	16250,	17250,	18500,	19250,	19750,	21000,	
		8000,	14500,	14500,	16000,	17500,	18500,	19000,	20000,	21500,	
		10000,	14500,	15000,	15000,	15000,	15500,	19500,	15500,	22500,	
	},

   	controller = {
		boost_start	= 0,
		march_start = 0,
	},

	control_block = {
		default_cruise_height = 600.0,
	},


	boost = {				--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,
	},

	march = {
		impulse			= 3000,
		fuel_mass		= 250,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 20000,
		thrust_Tau		= 0.0018,

		nozzle_position						= {{-2.26, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,

		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
	},

	engine_control = {
		default_speed	= 250,
		K				= 240,
		Kd				= 1.0,
		Ki				= 0.01,
		speed_delta		= 5,
	},

	seeker = {
		delay				= 0.0,
		op_time				= 800,
		activate_on_update	= 1,

		FOV					= math.rad(60),

		max_target_speed			= 33,
		max_target_speed_rnd_coeff	= 10,

		max_lock_dist		= 30000,
	},

	ins = {
		aim_sigma		= 350,
		check_AI		= 1,
		error_coeff		= 0.03,
	},

	fm = {
		mass        = 2000,
		caliber     = 0.76,
		cx_coeff    = {1,0.39,0.38,0.236,1.31},
		L           = 7,
		I           = 1 / 12 * 2000.0 * 7 * 7,
		Ma          = 0.68,
		Mw          = 1.116,
		wind_sigma	= 0.0,
		wind_time	= 1000.0,
		Sw			= 1.4,
		dCydA		= {0.07, 0.036},
		A			= 0.5,
		maxAoa		= 0.3,
		finsTau		= 0.02,
		Ma_x		= 3,
		Ma_z		= 3,
		Mw_x		= 2.6,
	},

	autopilot =
	{
		glide_height				= 600,
		dont_climb_on_cruise_height	= 0,
		vel_proj_div 				= 6.0,
		default_glide_height		= 600,
		pre_maneuver_glide_height	= 600,
		skim_glide_height			= 8,
		use_start_bar_height		= 1,
		altim_vel_k					= 4,

		delay				= 0.5,
		op_time				= 9999,
		Kw					= 2.4,
		Ks					= 1.0,
		K					= 1.0,
		Kd 					= 0.0,
		Ki 					= 10.0,
		Kx					= 0.04,
		Kdx					= 0.001,
		w_limit				= math.rad(2.5),
		fins_limit			= 1.4,
		fins_limit_x		= 0.5,
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	0,
								500,	0},

		max_climb_angle		= math.rad(10),
		max_dive_angle		= math.rad(-30),
		max_climb_ang_hdiff	= 180,
		max_dive_ang_hdiff	= -500,

		Ksd						= 0.0,
		Ksi						= 0.0,
		integr_val_limit		= 0.5,
		hor_err_limit			= 0.5,
		max_climb_vel			= 200,
		min_climb_vel			= 120,
		min_climb_vel_factor	= 0,
		max_climb_h				= 3000,
		min_climb_h				= 10000,
		min_climb_h_factor		= 0.5,
		
		inertial_km_error		= 6.0,
		glide_height_eq_error	= 0.03,

		
		vert_ctrl_data 		= {	100,	math.rad(-24),
								115,	math.rad(-16),
								130,	math.rad(-8),
								145,	math.rad(0),
								185,	math.rad(10),	},
	},

	final_autopilot = {
		delay				= 0.0,
		op_time				= 9999,
		Kw					= 1.0,
		Ks					= 20.0,
		K					= 5.0,
		Kd 					= 0.0,
		Ki 					= 0.0,
		Kx					= 0.0,
		Kix					= 0.0,
		w_limit				= math.rad(10),
		fins_limit			= 1.4,
		rotated_WLOS_input	= 0,
		conv_input			= 0,
		PN_dist_data 		= {	2000,	1,
								500,	1},

		add_err_val				= 0,
		add_err_vert			= 0,
		add_out_val				= 0.1,
		add_out_vert			= 1,
		loft_angle				= math.rad(6),
		loft_trig_angle			= math.rad(10),
		K_loft_err				= 1,
		loft_angle_vert			= 1,
		loft_active_by_default	= 0,
	},

	triggers_control = {
		action_wait_timer				= 5,	-- wait for dist functions n sen, then set default values
		default_sensor_tg_dist			= 11000, -- turn on seeker and start horiz. correction if target is locked
		default_final_maneuver_tg_dist	= 7000,
		default_straight_nav_tg_dist	= 7000,
		default_destruct_tg_dist		= 3000,	-- if seeker still can not find a target explode warhead after reaching pred. target point + n. km
		trigger_by_path					= 1,
		final_maneuver_trig_v_lim		= 3,
		use_horiz_dist					= 1,
		pre_maneuver_glide_height		= 600,	-- triggers st nav instead of fin. maneuver if h>2*pre_maneuver_glide_height at fin. maneuver distance
		min_cruise_height				= 600,
		min_cruise_height_trigger_sum	= 11000,
		min_cruise_height_trigger_mlt	= 237/33,
	},	
	
    Damage_correction_coeff = 1.0,

    warhead        = predefined_warhead("KD_63"),
    warhead_air    = predefined_warhead("KD_63"),
}

declare_weapon(KD63B)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{KD_63B}",
	attribute		= KD63B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "kd63b.png",
	displayName		= _("KD-63B"),
	Weight			= KD63B.mass,
	Elements  		= {{ShapeName = "kd63b"}},
})

KD20 =
{
	category		= CAT_MISSILES,
	name			= "KD_20",
	user_name		= _("KD-20"),
	display_name_short = "KD-20",
	scheme			= "sat_cruise_missile",
	class_name		= "wAmmunitionSelfHoming",
	model			= "kd20",
	mass			= 1700,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort			= 0,
	Head_Type		= 5,
	sigma			= {20, 20, 20},
	M				= 1700.0,
	H_max			= 13000.0,
	H_min			= -1,
	Diam			= 600.0,
	Cx_pil			= 8,
	D_max			= 2500000.0,
	D_min			= 20000.0,
	Head_Form		= 0,
	Life_Time		= 10000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 220.0,
	Mach_max		= 0.9,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 2500000.0,
	H_min_t			= 0.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back			= -3.392,
	Y_back			= 0.064,
	Z_back			= 0.0,
	Reflection		= 0.1691,
	KillDistance	= 0.0,
	
	
	LaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			0,			2500000,	2520000,	
		2000,	2500000,	2500000,	2510000,	2540000,	
		7000,	2540000,	2550000,	2550000,	2560000,	
		12500,	2570000,	2570000,	2580000,	2590000,	
	},
		
	MinLaunchDistData =
	{
		4,		4,

				100,		125,		175,		250,		
		500,	0,			0,			20000,		21000,	
		2000,	24000,		25000,		26000,		27000,	
		7000,	15000,		15000,		16000,		17000,	
		12500,	16000,		18000,		19000,		20000,	
	},	
	
	add_attributes = {"Cruise missiles", "Air"},
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "KD_20",
			file	 = "kd20",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("KD-20"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1700,  
		caliber     = 0.6,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.8,
		I           = 1 / 12 * 1700.0 * 6.8 * 6.8,
		Ma          = 3,
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.5,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	seeker = {
		coalition				= 1,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},

	control_block ={
		seeker_activation_dist		= 15500,
		default_cruise_height		= 55,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},
	
	final_autopilot =		{
		delay				= 0,
		K					= 72,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.72,
		useJumpByDefault	= 1,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.72,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3000,
		fuel_mass		= 400.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-2.25, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("KD_20"),
	warhead_air = predefined_warhead("KD_20"),
}

declare_weapon(KD20)


declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{KD_20}",
	attribute		= KD20.wsTypeOfWeapon,
	Count 			= 1,
	Picture			= "kd20.png",
	displayName		= _("KD-20"),
	Weight			= KD20.mass,
	Elements  		= {{ShapeName = "kd20"}},
})


X_555 =
{
	category		= CAT_MISSILES,
	name			= "X_555",
	user_name		= _("Kh-555"),
	display_name_short = _("Kh-555"),
	scheme			= "KH-555",
	class_name		= "wAmmunitionCruise",
	model			= "CHAP_Kh555",
	mass			= 1280,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort = 0,
	Head_Type = 5,
	sigma = {20, 20, 20},
	M = 1280.0,
	H_max = 12000.0,
	H_min = -1,
	Diam = 700.0,
	Cx_pil = 19.9,
	D_max = 2000000.0,
	D_min = 22000.0,
	Head_Form = 0,
	Life_Time = 12000.0,
	Nr_max = 16,
	v_min = 170.0,
	v_mid = 230.0,
	Mach_max = 0.85,
	t_b = 0.0,
	t_acc = 6.0,
	t_marsh = 12000.0,
	Range_max = 2000000.0,
	H_min_t = 0.0,
	Fi_start = 0.25,
	Fi_rak = 3.14152,
	Fi_excort = 0.35,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	-- No exhaust (turbo)
	X_back = -2.356,
	Y_back = -0.618,
	Z_back = 0.0,
	Reflection = 0.1656,
	KillDistance = 0.0,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	RouteDistData = {
		m_climb_dist_k	= 10,
		deg_turn_dist_k	= 50,
		min_cruise_vel	= 150,
		accel_dist_k	= 20,
	},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "KH_555",
			file	 = "CHAP_Kh555",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("Kh-555"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1280,  
		caliber     = 0.62,  
		cx_coeff    = {1, 0.3, 0.82, 0.035, 1.25},
		L           = 6.04,
		I           = 1 / 12 * 1280.0 * 6.04 * 6.04,
		Ma          = 3,
		Mw          = 10,
		wind_sigma	= 1000.0,
		wind_time	= 20.0,
		Sw			= 1.4,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	sat_seeker = {
		CEP 					= 5.0,
		coalition				= 1,
		coalition_rnd_coeff		= 5.0,
	},
	
	seeker = {
		CEP_dist_data =  {	1000,	10,
							2000,	20},
	},

	control_block ={
		seeker_activation_dist		= 20000,
		default_cruise_height		= 50,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 1.6,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 450,
		use_horiz_dist				= 1,
		stab_aim_diff				= 0.2,
		stab_vert_diff				= 50,
	},
	
	final_autopilot =		{
		delay				= 5,
		K					= 180,
		Ki					= 0.001,
		Kg					= 4,
		finsLimit			= 0.65,
		useJumpByDefault	= 1,
		J_Power_K			= 2.4,
		J_Diff_K			= 0.2,
		J_Int_K				= 0,
		J_Angle_K			= 0.22,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.6,
		J_Trigger_Vert		= 1,
		hKp_err				= 160,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= math.rad(60),
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 8,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,	

		inertial_km_error			= 1.6,
		glide_height_abs_error		= 12.0,
		glide_height_eq_error		= 12.0,
		stab_vel_abs_error			= 16.0,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3300,
		fuel_mass		= 240.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -150,
		max_thrust		= 3500,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-3.05, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 1,
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("X_555"),
	warhead_air = predefined_warhead("X_555"),
}

declare_weapon(X_555)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{Kh-555}",
	attribute		= X_555.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "CHAP_Kh555.png",
	displayName		= _("Kh-555"),
	Weight			= X_555.mass,
	Elements  		= {{ShapeName = "CHAP_Kh555"}},
})


X_101 =
{
	category		= CAT_MISSILES,
	name			= "X_101",
	user_name		= _("Kh-101"),
	display_name_short = _("Kh-101"),
	scheme			= "KH-101",
	class_name		= "wAmmunitionCruise",
	model			= "CHAP_Kh101",
	mass			= 2300,
	
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

	Escort = 0,
	Head_Type = 5,
	sigma = {20, 20, 20},
	M = 2300.0,
	H_max = 12000.0,
	H_min = -1,
	Diam = 742.0,
	Cx_pil = 19.9,
	D_max = 5000000.0,
	D_min = 22000.0,
	Head_Form = 0,
	Life_Time = 12000.0,
	Nr_max = 16,
	v_min = 170.0,
	v_mid = 230.0,
	Mach_max = 0.85,
	t_b = 0.0,
	t_acc = 6.0,
	t_marsh = 12000.0,
	Range_max = 5000000.0,
	H_min_t = 0.0,
	Fi_start = 0.25,
	Fi_rak = 3.14152,
	Fi_excort = 0.35,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	-- No exhaust (turbo)
	X_back = -2.356,
	Y_back = -0.618,
	Z_back = 0.0,
	Reflection = 0.1, --Decreased from 0.1656 to 0.1 WEAP-1621
	KillDistance = 0.0,
	
	add_attributes = {"Cruise missiles", "Anti-Ship missiles", "Air"},
	
	RouteDistData = {
		m_climb_dist_k	= 10,
		deg_turn_dist_k	= 50,
		min_cruise_vel	= 150,
		accel_dist_k	= 20,
	},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},
		
	shape_table_data =
	{
		{
			name	 = "KH_101",
			file	 = "CHAP_Kh101",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("KH-101"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 2400,  
		caliber     = 0.742,  
		cx_coeff    = {1, 0.3, 0.82, 0.035, 1.25},
		L           = 7.45,
		I           = 1 / 12 * 2400.0 * 7.45 * 7.45,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.5,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},

	seeker = {
		CEP_dist_data =  {	2000,	5,
							5000,	20},
	},

	control_block ={
		seeker_activation_dist		= 15000,
		default_cruise_height		= 50,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 1.6,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 450,
		use_horiz_dist				= 1,
		stab_aim_diff				= 0.2,
		stab_vert_diff				= 50,
	},
	
	final_autopilot =		{
		delay				= 5,
		K					= 140,
		Ki					= 0.001,
		Kg					= 5,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 6.0,
		J_Diff_K			= 1.0,
		J_Int_K				= 0,
		J_Angle_K			= 0.22,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 7,
		Kii_ver				= 0.18,
		Kd_ver				= 0.018,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 75,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 5,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 35,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,	

		inertial_km_error			= 4,
		glide_height_abs_error		= 12.0,
		glide_height_eq_error		= 12.0,
		stab_vel_abs_error			= 16.0,
	},
	
	controller = {
		boost_start	= 0,
		march_start = 0.8,
	},
	
	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	march = {
		impulse			= 3300,
		fuel_mass		= 1250.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -150,
		max_thrust		= 3500,
		thrust_Tau		= 0.0017,
		
		nozzle_position						= {{-3.40, -0.25, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.5,
		smoke_color							= {0.0, 0.5, 0.5},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,	
		
		start_burn_effect			= 0,
	},

	play_booster_animation = {
		val = 0,
	},
	
	warhead		= predefined_warhead("X_101"),
	warhead_air = predefined_warhead("X_101"),
}

declare_weapon(X_101)

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{Kh-101}",
	attribute		= X_101.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= 0.0018,
	Picture			= "CHAP_Kh101.png",
	displayName		= _("Kh-101"),
	Weight			= X_101.mass,
	Elements  		= {{ShapeName = "CHAP_Kh101"}},
})
